#ifndef MYWINDOW_H_INCLUDED
#define MYWINDOW_H_INCLUDED
#include<gtkmm.h>
#include "mywindow1_member.h"
#include "mywindow2_guest.h"
#include "mywindow3_librarian.h"
#include "mywindow4_admin.h"
#include "loginscr.h"
mywindow::mywindow(){
    set_position(Gtk::WIN_POS_CENTER);
     //SIZE OF THE WINDOWS

    set_default_size(500, 300);
    set_title("WELCOME");

    //VIRTUAL BOX

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    //ADDING A GRID TO THE VBOX

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    //A LABEL AT THE TOP

    Gtk::Label *heading1 = Gtk::manage(new Gtk::Label(""));
    heading1->set_hexpand(true);
    grid->attach(*heading1, 0, 0, 1, 1);

    Gtk::Label *heading = Gtk::manage(new Gtk::Label("SELECT YOUR LOGIN TYPE"));
    grid->attach(*heading, 1, 0, 1, 1);

    Gtk::Label *head = Gtk::manage(new Gtk::Label(""));
    grid->attach(*head, 1, 1, 1, 1);

    Gtk::Label *heading2 = Gtk::manage(new Gtk::Label(""));
    heading2->set_hexpand(true);
    grid->attach(*heading2, 2, 0, 1, 1);

    Gtk::Label *bottom = Gtk::manage(new Gtk::Label(""));
    grid->attach(*bottom, 1, 6, 1, 1);


    //ADDING BUTTONS

    Gtk::Button *b1 = Gtk::manage(new Gtk::Button("MEMBER LOGIN"));
    b1->signal_clicked().connect(sigc::mem_fun(*this, &mywindow::on_button1_click));
    grid->attach(*b1, 1, 2, 1, 1);
    Gtk::Button *b2 = Gtk::manage(new Gtk::Button("GUEST USER"));
    b2->signal_clicked().connect(sigc::mem_fun(*this, &mywindow::on_button2_click));
    grid->attach(*b2, 1, 3, 1, 1);
    Gtk::Button *b3 = Gtk::manage(new Gtk::Button("LIBRARIAN LOGIN"));
    b3->signal_clicked().connect(sigc::mem_fun(*this, &mywindow::on_button3_click));
    grid->attach(*b3, 1, 4, 1, 1);
    Gtk::Button *b4 = Gtk::manage(new Gtk::Button("ADMINSTRATOR LOGIN"));
    b4->signal_clicked().connect(sigc::mem_fun(*this, &mywindow::on_button4_click));
    grid->attach(*b4, 1, 5, 1, 1);


    vbox->show_all();
}

//DESTRUCTOR FUNCTION

mywindow::~mywindow(){
    std::cout<<"Deleting mywindow";
    std::map<int, mem_login*>::iterator iter;
    for (iter = popups.begin(); iter != popups.end(); iter++)
    {
        mem_login *popup = iter->second;

        delete popup->popup;
        delete popup;
    }
}




void mywindow::on_button1_click()
{
    mem_login *popup = new mem_login;
    popup->popup = new mywindow1;

    popup->popup->set_title("MEMBER LOGIN");

    popup->popup->show();
}

void mywindow::on_button2_click()
{
    guest_mem_login *popup = new guest_mem_login;
    popup->popup = new mywindow2;

    popup->popup->set_title("GUEST LOGIN");

    popup->popup->show();
}

void mywindow::on_button3_click()
{
    lib_login *popup = new lib_login;
    popup->popup = new mywindow3;

    popup->popup->set_title("LIBRARIAN LOGIN");

    popup->popup->show();
}

void mywindow::on_button4_click()
{
    admin_login *popup = new admin_login;
    popup->popup = new mywindow4;

    popup->popup->set_title("ADMINSTRATOR LOGIN");

    popup->popup->show();
}


void mywindow::on_quit_click(){
    hide();
}


#endif // MYWINDOW_H_INCLUDED
